#include "maindefs.h"
#include "led_driver.h"
#include "delays.h"
#include <spi.h>

unsigned int led_last_value;

#ifdef _SPI2_V1
/* Output Pins:
 * RA0 - LED Display Latch Enable (PPS)
 * RA1 - LED Display CLK (PPS)
 * RA2 - LED Display DIN (PPS)
 * RA3 - LED Display Output Enable (PPS)
 */
#endif

#ifdef _SPI2_V2
/* Output Pins:
 * RA0 - LED Display CLK (PPS)
 * RA1 - LED Display DIN (PPS)
 * RA2 - LED Display Latch Enable (PPS)
 * RA3 - LED Display Output Enable (PPS)
 */
#endif

void led_driver_init() {
#ifdef _SPI2_V1
    TRISAbits.TRISA0 = 0;   // LE
    TRISAbits.TRISA1 = 0;   // CLK
    TRISAbits.TRISA2 = 0;   // DAT
    TRISAbits.TRISA3 = 0;   // OE
    
    LATAbits.LATA0 = 0; // LE
    LATAbits.LATA1 = 0; // CLK
    LATAbits.LATA2 = 0; // DAT
    LATAbits.LATA3 = 0; // OE
#endif

#ifdef _SPI2_V2
    TRISAbits.TRISA0 = 0;   // CLK
    TRISAbits.TRISA1 = 0;   // DAT
    TRISAbits.TRISA2 = 0;   // LE
    TRISAbits.TRISA3 = 0;   // OE
    
    LATAbits.LATA0 = 0; // CLK
    LATAbits.LATA1 = 0; // DAT
    LATAbits.LATA2 = 1; // LE
    LATAbits.LATA3 = 0; // OE

    RPOR0 = 10; // CLK
    RPOR1 = 9;  // DATA
    OpenSPI2(SPI_FOSC_4, MODE_00, SMPMID);
#endif

    led_last_value = 0;
    led_driver_data(0);
    led_driver_data(0);
}

void led_driver_clock() {
#ifdef _SPI2_V1
    LATAbits.LATA1 = 0x1; // Simple clock output toggle
    Nop();
    LATAbits.LATA1 = 0x0;
    Nop();
#endif
#ifdef _SPI2_V2
    LATAbits.LATA0 = 0x1; // Simple clock output toggle
    Nop();
    LATAbits.LATA0 = 0x0;
    Nop();
#endif
}

void led_driver_data(char val) {
#ifdef _SPI2_V1
    int i;
    LATAbits.LATA0 = 0x0; // Set latch low to pause display
    for (i = 0; i < 8; i++) {
        LATAbits.LATA2 = val & 0x1; // Shift out bits
        led_driver_clock();
        val >>= 1;
    }
    LATAbits.LATA0 = 0x1; // Set latch high to resume display
#endif

#ifdef _SPI2_V2
    WriteSPI2(val);
#endif
}

void led_driver_num(unsigned char data) {
    unsigned char tmp = 0;
    led_last_value = 0;
    
    // Determine right character (1s digit)
    tmp = data % 10;
    switch (tmp) {
#ifdef _SPI2_V1
        case 0:
            led_last_value |= 0x0D70;
            break;
        case 1:
            led_last_value |= 0x0140;
            break;
        case 2:
            led_last_value |= 0x0E60;
            break;
        case 3:
            led_last_value |= 0x0760;
            break;
        case 4:
            led_last_value |= 0x0350;
            break;
        case 5:
            led_last_value |= 0x0730;
            break;
        case 6:
            led_last_value |= 0x0F30;
            break;
        case 7:
            led_last_value |= 0x0170;
            break;
        case 8:
            led_last_value |= 0x0F70;
            break;
        case 9:
            led_last_value |= 0x0770;
            break;
#endif
#ifdef _SPI2_V2
            case 0:
            led_last_value |= 0x0EB0;
            break;
        case 1:
            led_last_value |= 0x0280;
            break;
        case 2:
            led_last_value |= 0x0670;
            break;
        case 3:
            led_last_value |= 0x06E0;
            break;
        case 4:
            led_last_value |= 0x0AC0;
            break;
        case 5:
            led_last_value |= 0x0CE0;
            break;
        case 6:
            led_last_value |= 0x0CF0;
            break;
        case 7:
            led_last_value |= 0x0E80;
            break;
        case 8:
            led_last_value |= 0x0EF0;
            break;
        case 9:
            led_last_value |= 0x0EE0;
            break;
#endif
    }

    // Determine left character (10s digit)
    tmp = data / 10;
    switch (tmp) {
#ifdef _SPI2_V1
        case 0:
            led_last_value |= 0xE00D;
            break;
        case 1:
            led_last_value |= 0x2008;
            break;
        case 2:
            led_last_value |= 0xC00E;
            break;
        case 3:
            led_last_value |= 0x600E;
            break;
        case 4:
            led_last_value |= 0x200B;
            break;
        case 5:
            led_last_value |= 0x6007;
            break;
        case 6:
            led_last_value |= 0xE007;
            break;
        case 7:
            led_last_value |= 0x200D;
            break;
        case 8:
            led_last_value |= 0xE00F;
            break;
        case 9:
            led_last_value |= 0x600F;
            break;
#endif
#ifdef _SPI2_V2
            case 0:
            led_last_value |= 0xB007;
            break;
        case 1:
            led_last_value |= 0x1004;
            break;
        case 2:
            led_last_value |= 0x7003;
            break;
        case 3:
            led_last_value |= 0x7006;
            break;
        case 4:
            led_last_value |= 0xD004;
            break;
        case 5:
            led_last_value |= 0xE006;
            break;
        case 6:
            led_last_value |= 0xE007;
            break;
        case 7:
            led_last_value |= 0xB004;
            break;
        case 8:
            led_last_value |= 0xF007;
            break;
        case 9:
            led_last_value |= 0xF006;
            break;
#endif
    }

#ifdef _SPI2_V1
    led_driver_data(led_last_value & 0x00FF);
    led_driver_data((led_last_value & 0xFF00) >> 8);
#endif
#ifdef _SPI2_V2
    led_driver_data((led_last_value & 0xFF00) >> 8);
    led_driver_data(led_last_value & 0x00FF);
#endif
}

void led_driver_show_last() {
#ifdef _SPI2_V1
    led_driver_data(led_last_value & 0x00FF);
    led_driver_data((led_last_value & 0xFF00) >> 8);
#endif
#ifdef _SPI2_V2
    led_driver_data((led_last_value & 0xFF00) >> 8);
    led_driver_data(led_last_value & 0x00FF);
#endif
}